@extends('layouts.app')

@section('main')
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1><i class="fas fa-edit"></i> Quick Edit Product</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('product.index') }}">Products</a></li>
                        <li class="breadcrumb-item active">Quick Edit</li>
                    </ol>
                </div>
            </div>
        </div>

        <!-- Alert Messages -->
        @if (session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="fas fa-check-circle"></i> {{ session('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif
        @if (session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif
        @if ($errors->any())
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-bolt"></i> 
                            Quick Edit: {{ $product->name }}
                        </h3>
                        <div class="card-tools">
                            <a href="{{ route('product.index') }}" class="btn btn-sm btn-secondary">
                                <i class="fas fa-arrow-left"></i> Back
                            </a>
                        </div>
                    </div>

                    <form method="POST" action="{{ route('product.updateSimple', $product->id) }}">
                        @csrf
                        @method('PUT')
                        
                        <div class="card-body">
                            <!-- Product Information Display -->
                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <strong>Product ID:</strong> #{{ $product->id }}
                                </div>
                                <div class="col-md-6">
                                    <strong>IMEI/SN:</strong> {{ $product->imei_or_sn ?? 'N/A' }}
                                </div>
                            </div>
                            
                            <hr>

                            <!-- Editable Fields -->
                            <div class="form-group">
                                <label for="name">
                                    <i class="fas fa-tag"></i> Product Name <span class="text-danger">*</span>
                                </label>
                                <input type="text" 
                                       class="form-control @error('name') is-invalid @enderror" 
                                       id="name" 
                                       name="name" 
                                       value="{{ old('name', $product->name) }}" 
                                       required 
                                       maxlength="255"
                                       placeholder="Enter product name"
                                       autofocus>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="buy_price">
                                    <i class="fas fa-dollar-sign"></i> Buy Price <span class="text-danger">*</span>
                                </label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">$</span>
                                    </div>
                                    <input type="number" 
                                           class="form-control @error('buy_price') is-invalid @enderror" 
                                           id="buy_price" 
                                           name="buy_price" 
                                           value="{{ old('buy_price', $product->buy_price) }}" 
                                           step="0.01" 
                                           min="0" 
                                           required
                                           placeholder="0.00">
                                    @error('buy_price')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                @if($product->sell_price)
                                    <small class="text-muted">
                                        <i class="fas fa-info-circle"></i> 
                                        Sell Price: ${{ number_format($product->sell_price, 2) }}
                                    </small>
                                @endif
                            </div>

                            <div class="form-group">
                                <label for="stock">
                                    <i class="fas fa-boxes"></i> Stock Quantity <span class="text-danger">*</span>
                                </label>
                                <input type="number" 
                                       class="form-control @error('stock') is-invalid @enderror" 
                                       id="stock" 
                                       name="stock" 
                                       value="{{ old('stock', $product->stock) }}" 
                                       min="0" 
                                       required
                                       placeholder="0">
                                @error('stock')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="text-muted">
                                    <i class="fas fa-info-circle"></i> 
                                    Current stock: {{ $product->stock }} units
                                </small>
                            </div>
                        </div>

                        <div class="card-footer">
                            <div class="row">
                                <div class="col-md-6">
                                    <a href="{{ route('product.index') }}" class="btn btn-secondary">
                                        <i class="fas fa-times"></i> Cancel
                                    </a>
                                    <a href="{{ route('product.edit', $product->id) }}" class="btn btn-info ml-2">
                                        <i class="fas fa-cogs"></i> Full Edit
                                    </a>
                                </div>
                                <div class="col-md-6 text-right">
                                    <button type="submit" class="btn btn-success btn-lg">
                                        <i class="fas fa-save"></i> Update Product
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <script>
        // Auto-dismiss alerts after 5 seconds
        setTimeout(function() {
            $('.alert').alert('close');
        }, 5000);

        // Form validation feedback
        document.getElementById('buy_price').addEventListener('input', function() {
            const sellPrice = {{ $product->sell_price ?? 0 }};
            const buyPrice = parseFloat(this.value);
            
            if (buyPrice > 0 && sellPrice > 0) {
                const profit = sellPrice - buyPrice;
                const margin = ((profit / sellPrice) * 100).toFixed(2);
                
                // You can add profit margin display here if needed
            }
        });
    </script>
@endsection